# migrate {#migrate}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`migrate(backupDir, [backupDBPath], [backupTableName], [newDBPath=backupDBPath], [newTableName=backupTableName], [keyPath])`

## Arguments {#arguments}

**backupDir** is a string indicating the directory to save the backup.

**backupDBPath** is a string indicating the path of a database.

**backupTableName** is a string indicating a table name.

**newDBPath** is a string indicating the new database name. If not specified, the default value is *backupDBPath*. To specify the parameter, make sure that the storage engine of the backup database is the same as the engine of *newDBPath*, and the *partitionScheme* must be the same \(except for VALUE\). For a VALUE partitioned database, the partitioning scheme of the backup database must be a subset of that of the database to be restored.

**newTableName** is a string indicating the new table name. If not specified, the default value is *backupTableName*.

**keyPath** \(optional, Linux only\) is a STRING scalar that specifies the path to the key file used for restoring an encrypted backup. The key version used for restoring the data must match the version specified during the backup. Note that when restoring an encrypted table, both the backup table and the target table must use the same encryption mode \(i.e., the same *encryptMode* parameter specified during table creation\).

## Details {#details}

Restore the backup. It returns a table containing the restored data of each table. It must be executed by a logged-in user.

The `migrate` function has the following 3 usages:

-   `migrate(backupDir)`: Restore the backup of all databases in this directory. The restored database name and table name are the same as the original ones.

-   `migrate(backupDir, backupDBPath)`: Restore the backup of the specified database in this directory. The restored database name and table name are the same as the original ones.

-   `migrate(backupDir, backupDBPath, backupTableName, [newDBPath], [newTableName])`: Restore the backup of the specified table of the specified database in the directory.

    -   If *newDBPath* and *newTableName* are not specified, the restored database name and table name are the same as the original ones.

    -   If *newDBPath* and *newTableName* are specified, the restored database name and table name will be *newDBPath* and *newTableName*, respectively.


## Examples {#examples}

Create two sample databases and back up them to the same directory:

```
backupDir="/home/DolphinDB/backup"

n = 1000000
t1 = table(rand(2012.12.01..2012.12.10, n) as date, rand(`AAPL`IBM`GOOG`MSFT, n) as sym, rand(1000.0,n) as price)
t2 = table(rand(2012.12.01..2012.12.10, n) as date, rand(`AAPL`IBM`GOOG`MSFT, n) as sym, rand(1000,n) as qty)
db1 = database("dfs://db1", VALUE, 2012.12.01..2012.12.10)
trades1 = db1.createPartitionedTable(t1, `trades1, `date).append!(t1)
trades2 = db1.createPartitionedTable(t2, `trades2, `date).append!(t2)

n = 1000000
t1 = table(rand(2012.12.01..2012.12.10, n) as date, rand(`AAPL`IBM`GOOG`MSFT, n) as sym, rand(1000.0,n) as price)
t2 = table(rand(2012.12.01..2012.12.10, n) as date, rand(`AAPL`IBM`GOOG`MSFT, n) as sym, rand(1000,n) as qty)
db1 = database("dfs://db2", VALUE, `AAPL`IBM`GOOG`MSFT)
quotes1 = db1.createPartitionedTable(t1, `quotes1, `sym).append!(t1)
quotes2 = db1.createPartitionedTable(t2, `quotes2, `sym).append!(t2)

backup(backupDir, <select * from trades1>, true)
backup(backupDir, <select * from trades2>, true)
backup(backupDir, <select * from quotes1>, true)
backup(backupDir, <select * from quotes2>, true)
```

Delete the original database:

```
dropDatabase("dfs://db1")
dropDatabase("dfs://db2")
```

Example 1. Restore all databases

```
migrate(backupDir);
```

|dbName|tableName|success|errorMsg|
|------|---------|-------|--------|
|dfs://db1|trades1|1||
|dfs://db1|trades2|1||
|dfs://db2|quotes2|1||
|dfs://db2|quotes1|1||

Example 2. Restore all tables in the database *dfs://db1*

```
migrate(backupDir, "dfs://db1");
```

|dbName|tableName|success|errorMsg|
|------|---------|-------|--------|
|dfs://db1|trades1|1||
|dfs://db1|trades2|1||

Example 3. Restore table trades1 in the database *dfs://db1*

Example 3.1 When we do not specify the new database name and table name

```
migrate(backupDir, "dfs://db1", "trades1");
```

|dbName|tableName|success|errorMsg|
|------|---------|-------|--------|
|dfs://db1|trades1|1||

Example 3.2 Specify the new database name and table name

```
migrate(backupDir, "dfs://db1", "trades1", "dfs://db3", "trades");
```

|dbName|tableName|success|errorMsg|
|------|---------|-------|--------|
|dfs://db1|trades1|1||

```
exec count(*) from loadTable("dfs://db3", "trades")
// output: 1000000
```

Related function: [backup](../b/backup.md)

