# mifirstNot {#mifirstnot}

## Syntax {#syntax}

`mifirstNot(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the index of the first non-null element of *X* in a sliding window \(based on the number of elements or time\).

## Examples {#examples}

```
v = NULL NULL 2 3 4 8 NULL 5 -2 3 -1 0 NULL
mifirstNot(v, 3)
// output: [,,2,1,0,0,0,0,1,0,0,0,0]

m = matrix(NULL 1 2 3, 1 NULL 2 3, NULL NULL 3 4, 1 2 3 4)
n = mifirstNot(m, 2)
n
```

|\#1|\#2|\#3|\#4|
|---|---|---|---|
|||||
|1|0|-1|0|
|0|1|1|0|
|0|0|0|0|

``` {#codeblock_e5z_kgd_gbc}
T = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.06, 2022.01.07]
X = NULL 2 NULL 4 5
X1 = indexedSeries(T, X)
mifirstNot(X1, 2, 1)
```

| |\#1|
|---|---|
|2022.01.01|-1|
|2022.01.02|1|
|2022.01.03|0|
|2022.01.06|0|
|2022.01.07|0|

Related function: [milastNot](milastNot.md)

