# microsecond {#microsecond}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`microsecond(X)`

## Arguments {#arguments}

**X** is a scalar/vector of type TIME, TIMESTAMP, NANOTIME or NANOTIMESTAMP.

## Details {#details}

For each element in *X*, return a number from 0 to 999999 indicating which microsecond of the second it falls in.

## Examples {#examples}

```
microsecond(13:30:10.008);
// output: 8000

microsecond([2012.12.03 01:22:01.999999000, 2012.12.03 01:22:01.000456000, 2012.12.03 01:25:08.000000234]);
// output: [999999,456,0]
```

Related functions: [dayOfYear](../d/dayOfYear.md), [dayOfMonth](../d/dayOfMonth.md), [quarterOfYear](../q/quarterOfYear.md), [monthOfYear](monthOfYear.md), [weekOfYear](../w/weekOfYear.md), [hourOfDay](../h/hourOfDay.md), [minuteOfHour](minuteOfHour.md), [secondOfMinute](../s/secondOfMinute.md), [millisecond](millisecond.md), [nanosecond](../n/nanosecond.md)

