# merge {#merge}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`merge(left, right, [how='inner'])`

## Arguments {#arguments}

**left** and **right** are both indexed series, or are both indexed matrices.

**how** is a string indicating how to merge *left* and *right*. It can take the value of 'inner', 'outer', 'left', 'right', or 'asof'. The default value is 'inner'.

## Details {#details}

Merge 2 indexed series or 2 indexed matrices.

## Examples {#examples}

```
a = indexedSeries(2012.01.01..2012.01.04, 1..4)
b = indexedSeries([2012.01.01, 2012.01.03, 2012.01.05, 2012.01.06], 5..8)
merge(a, b);
```

||series1|series2|
|---|-------|-------|
|2012.01.01|1|5|
|2012.01.03|3|6|

```
merge(a, b, 'left');
```

||series1|series2|
|---|-------|-------|
|2012.01.01|1|5|
|2012.01.02|2||
|2012.01.03|3|6|
|2012.01.04|4||

```
m1 = matrix([1.2, 7.8, 4.6, 5.1, 9.5], [0.15, 1.26, 0.45, 1.02, 0.33]).rename!([2012.01.01, 2015.02.01, 2015.03.01, 2015.04.01, 2015.05.01], `x1`x2).setIndexedMatrix!()
m2 = matrix([1.0, 2.0, 3.0, 4.0], [0.14, 0.26, 0.35, 0.48]).rename!([2015.02.01, 2015.02.16, 2015.05.01, 2015.05.02], `y1`y2).setIndexedMatrix!()
m = merge(m1, m2, 'asof');
```

||x1|x2|y1|y2|
|---|---|---|---|---|
|2012.01.01|1.2|0.15|||
|2015.02.01|7.8|1.26|1|0.14|
|2015.03.01|4.6|0.45|2|0.26|
|2015.04.01|5.1|1.02|2|0.26|
|2015.05.01|9.5|0.33|3|0.35|

