# member {#member}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`member(X, Y)` or `X.Y`

## Arguments {#arguments}

**X** is a table/dictionary.

**Y** is a member/attribute of *X*.

## Details {#details}

Return the specified member/attribute of an object.

## Examples {#examples}

```
x=1 2 3
y=4 5 6
t=table(x,y);

t.x;
// output: [1,2,3]

t.y;
// output: [4,5,6]

t.rows();
// output: 3

t.cols();
// output: 2

t.size();
// output: 3
// a table's size is defined as the number of its rows

d = dict(1 2 3, 4 5 6);
d;
/* output:
3->6
1->4
2->5
*/

d.2;
// output: 5
```

Since version 2.00.11.1/1.30.23.1, a line break can be introduced before any member access operators \(.\) to continue the call on the next line.

``` {#codeblock_qv2_hwj_g1c}
t = table(take(1..5,10) as a, take(6..10,10) as b, take(1..2,10) as c)

t.replaceColumn!("a",lpad(string(t.a),6,"0"))
     .replaceColumn!("b",rpad(string(t.b),6,"0")).add(100)
```

