# mean {#mean}

## Syntax {#syntax}

`mean(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

Calculate the average of *X*.

-   If *X* is a matrix, calculate the average of each column and return a vector.

-   If *X* is a table, calculate the average of each column and return a table.


This function is equivalent to [avg](../a/avg.md).

The calculation skips null values.

## Examples {#examples}

```
x=1 5 9;
mean(x);
// output: 5

x=1 5 9 NULL;
mean(x);
// output: 5

avg(x);
// output: 5

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
mean(m);
// output: [2,5]
```

Related center data tendency functions: [mode](mode.md), [med](med.md)

