# mcount {#mcount}

## Syntax {#syntax}

`mcount(X, window, [minPeriods=1])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the number of non-null values of *X* in a sliding window.

## Examples {#examples}

```
x = 7 4 5 8 9;
mcount(x, 3);
// output: [1,2,3,3,3]

mcount(x, 3, minPeriods=2);
// output: [,2,3,3,3]

x1 =1 2 3 NULL 5;
mcount(x1, 3);
// output: [1,2,3,2,2]

mcount(x1, 3, minPeriods=3);
// output: [,,3,,]

m=matrix(1 2 NULL 4 5, 6 7 8 9 NULL);
m;
```

|\#0|\#1|
|---|---|
|1|6|
|2|7|
||8|
|4|9|
|5||

```
mcount(m,3);
```

|\#0|\#1|
|---|---|
|1|1|
|2|2|
|2|3|
|2|3|
|2|2|

```
s=indexedSeries(date(2020.05.26)+1..8, 3 4 9 NULL 4 6 NULL 8)
mcount(s,4d)
```

|label|col1|
|-----|----|
|2020.05.27|1|
|2020.05.28|2|
|2020.05.29|3|
|2020.05.30|3|
|2020.05.31|3|
|2020.06.01|3|
|2020.06.02|2|
|2020.06.03|3|

```
mcount(s,1w)
```

|label|col1|
|-----|----|
|2020.05.27|1|
|2020.05.28|2|
|2020.05.29|3|
|2020.05.30|3|
|2020.05.31|4|
|2020.06.01|5|
|2020.06.02|5|
|2020.06.03|5|

Related functions: [count](../c/count.md)

