# mcorrTopN {#mcorrtopn}

## Syntax {#syntax}

`mcorrTopN(X, Y, S, window, top, [ascending=true], [tiesMethod='oldest'])`

Please see [mTopN](../Themes/mTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by the number of elements\), the function stably sorts *X* and *Y* by *S* in the order specified by *ascending*, then calculates the moving correlation of the first *top* pairs of elements in *X* and *Y*.

## Examples {#examples}

```
a =  2 5 3 1 9
b = 2 3 1 7 13
s = 6 8 4 2 7

mcorrTopN(a, b, s, 4, 3)
// output: [ , 1, 0.6547, -0.9333, 0.7206]

s2=2021.01.01 2021.02.03 2021.01.23 2021.04.06 2021.12.29
mcorrTopN(a, b, s2, 4, 3)
// output: [ , 1, 0.6547, 0.6547, -0.6547]

a1 = matrix(a, 4 3 6 2 3)
b1=matrix(3 7 9 3 2, b)
s1=matrix(2 3 1 7 3, s)
mcorrTopN(a, b1, s1, 4, 3)
```

|col1|col2|
|----|----|
|||
|1|1|
|0.5|0.6547|
|0.5|-0.9333|
|-0.9986|0.7206|

```
mcorrTopN(a1, b1, s, 4, 3)
```

|col1|col2|
|----|----|
|||
|1|-1|
|0.5|-0.982|
|0.866|-0.9333|
|-0.4018|-0.7206|

```
mcorrTopN(a1, b1, s1, 4, 3)
```

|col1|col2|
|----|----|
|||
|1|-1|
|0.5|-0.982|
|0.5|-0.9333|
|-0.9986|-0.7206|

```
n = 3000
ids = 1..3000
dates = take(2021.01.01..2021.10.01,n)
prices = rand(1000,n)
vals = rand(1000,n)
t = table(ids as id,dates as date,prices as price,vals as val)
dbName = "dfs://test_mcorrTopN_2"
if(existsDatabase(dbName))dropDB(dbName)
db = database(dbName,VALUE,1..5000)
pt = db.createPartitionedTable(t,"pt",`id).append!(t)
select mcorrTopN(price, val, id, 10, 5, true) from pt where date>2021.05.01
```

Related function: [mcorr](mcorr.md)

