# mbeta {#mbeta}

## Syntax {#syntax}

`mbeta(Y, X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the coefficient estimate of an ordinary-least-squares regression of *Y* on *X* in a sliding window.

## Examples {#examples}

```
x=0.011 0.006 -0.008 0.012 -0.016 -0.023 0.018
y=0.016 0.009 -0.012 0.022 0.003 -0.056 0.002
mbeta(y, x, 5);
// output: [,,,,0.818182,1.692379,1.188532]

mbeta(y, x, 5, 3);
// output: [,,1.479381,1.594701,0.818182,1.692379,1.188532]
```

```
x1 = indexedSeries(date(2020.06.05)+1..7, x)
y1 = indexedSeries(date(2020.06.05)+1..7, y)
mbeta(y1, x1, 5d);
```

|label|col1|
|-----|----|
|2020.06.06||
|2020.06.07|1.4|
|2020.06.08|1.4794|
|2020.06.09|1.5947|
|2020.06.10|0.8182|
|2020.06.11|1.6924|
|2020.06.12|1.1885|

```
mbeta(y1, x1, 1w);
```

|label|col1|
|-----|----|
|2020.06.06||
|2020.06.07|1.4|
|2020.06.08|1.4794|
|2020.06.09|1.5947|
|2020.06.10|0.8182|
|2020.06.11|1.6924|
|2020.06.12|1.2659|

Related function: [beta](../b/beta.md)

