# maxPositiveStreak {#maxpositivestreak}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`maxPositiveStreak(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix. The elements of *X* must be logic or integer values.

## Details {#details}

If *X* is a vector: return the maximum value of of the sum of consecutive positive elements of *X*.

If *X* is a matrix, return the maximum value of of the sum of consecutive positive elements in each column of *X*.

`maxPositiveStreak(X)` = `max(cumPositiveStreak(X))`

## Examples {#examples}

```
x=1 0 -1 1 2 2 2 1 0 -1 0 2;
cumPositiveStreak x;
// output: [1,0,0,1,3,5,7,8,0,0,0,2]

maxPositiveStreak x;
// output: 8

y=x$6:2;
y;
```

|\#0|\#1|
|---|---|
|1|2|
|0|1|
|-1|0|
|1|-1|
|2|0|
|2|2|

```
cumPositiveStreak(y);
```

|\#0|\#1|
|---|---|
|1|2|
|0|3|
|0|0|
|1|0|
|3|0|
|5|2|

```
maxPositiveStreak(y);
// output: [5,3]
```

Related function: [cumPositiveStreak](../c/cumPositiveStreak.md)

