# maxIgnoreNull {#maxIgnoreNull}

## Syntax {#Syntax .section}

`maxIgnoreNull(X, Y)`

## Arguments {#Arguments .section}

**X** and **Y** can be a numeric, LITERAL or TEMPORAL scalar, pair, vector or matrix.

## Details {#Details .section}

A binary scalar function that returns the maximum by comparing *X* with *Y*.

Difference between `max` and `maxIgnoreNull`:

-   `max`: Null values are treated as the minimum value if *nullAsMinValueForComparison=*true, otherwise comparison involving null values returns NULL.

-   `maxIgnoreNull`: Null values are ignored in comparison and non-null maximum is returned. If both elements in *X* and *Y* are null, NULL is returned. This function is not affected by configuration parameter *nullAsMinValueForComparison*.


## Examples {#Examples .section}

``` {#codeblock_plz_glq_3bc}
maxIgnoreNull(2,matrix(1  NULL 4,-1 4  0)) 
```

|\#0|\#1|
|---|---|
|2|2|
|2|4|
|4|2|

``` {#codeblock_rlz_glq_3bc}
maxIgnoreNull(matrix(10 3 NULL, 1 7 4),matrix(1  NULL 4,-1 4  0))
```

<table id="table_slz_glq_3bc"><tbody><tr><td>

\#0

</td><td>

\#1

</td></tr><tr><td>

10

</td><td>

1

</td></tr><tr><td>

3

</td><td>

7

</td></tr><tr><td>

-4

</td><td>

4

</td></tr></tbody>
</table>Use `minIgnoreNull` with `reduce` to calculate the minimum for matrices of the same shape stored in a tuple:

``` {#codeblock_u4g_4lq_3bc}
n1 = matrix(1 1 1, 5 5 5)
n2 = matrix(10 11 12, 0 NULL -5)
n3 = matrix(-1 1 NULL, -3 0 10)
reduce(minIgnoreNull, [n1,n2,n3])
```

|\#0|\#1|
|---|---|
|10|5|
|11|5|
|12|10|

**Related function**: [minIgnoreNull](minIgnoreNull.md)

**Parent topic:**[Functions](../../Functions/category.md)

