# matrix {#matrix}

## Syntax {#syntax}

`matrix(X1, [X2], ...)`

or

`matrix(dataType, rows, cols, [columnsCapacity], [defaultValue])`

or

`matrix(X)`

## Arguments {#arguments}

For the first case: **X1**, **X2**, **...** can be data objects including vector, matrix, table \(without SYMBOL columns\), tuple of vectors and their combination.

For the second case:

-   **dataType** is the data type of the matrix. Data types other than INT128, UUID, IPADDR, POINT and DURATION are supported.

-   **rows** is the number of rows.

-   **cols** is the number of cols.

-   **columnsCapacity** is the amount of memory \(in terms of the number of columns\) allocated to the matrix. When the number of columns exceeds *columnsCapacity*, the system will first allocate memory of 1.2~2 times of *capacity*, copy the data to the new memory space, and release the original memory.

-   **defaultValue** is the default value for the elements of the matrix. Without specifying *defaultValue*, all elements in the matrix are 0s for integers/doubles and null values for symbols.


For the third case: **X** is an array vector \([arrayVector](../../Programming/DataTypesandStructures/DataForms/Vector/arrayVector.md)\) and each vector in *X* must be of the same length.

## Details {#details}

Generate a matrix.

## Examples {#examples}

```
x=matrix(INT,3,2, ,1);
x;
```

|\#0|\#1|
|---|---|
|1|1|
|1|1|
|1|1|

``` {#codeblock_izb_wjm_cbc}
y = matrix(DECIMAL32(3),2,3)
y 
```

|\#0|\#1|\#2|
|---|---|---|
|0.000|0.000|0.000|
|0.000|0.000|0.000|

```
s=matrix(SYMBOL,2,2, ,`T);
s;
```

|\#0|\#1|
|---|---|
|T|T|
|T|T|

```
matrix(table(1 2 3 as id, 4 5 6 as value));
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
matrix([1 2 3, 4 5 6]);
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
matrix([1 2 3, 4 5 6], 7 8 9, table(0.5 0.6 0.7 as id), 1..9$3:3);
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|
|---|---|---|---|---|---|---|
|1|4|7|0.5|1|4|7|
|2|5|8|0.6|2|5|8|
|3|6|9|0.7|3|6|9|

``` {#codeblock_xtq_c3b_bbc}
matrix(`AA`BB`CC,`DD`EE`FF)
```

|\#0|\#1|
|---|---|
|AA|DD|
|BB|EE|
|CC|FF|

Error occurs when converting a table with SYMBOL columns to a matrix:

``` {#codeblock_shv_1fb_bdc}
t = table(symbol(["a", "b"]) as sym, [1, 2] as val)
matrix(t)
// output: matrix(t) => Failed to append a table object to a matrix.
```

Convert SYMBOL to STRING for matrix conversion:

``` {#codeblock_ejr_bfb_bdc}
t = table(string(["a", "b"]) as sym, [1, 2] as val)
matrix(t)
```

|\#1|\#2|
|---|---|
|a|1|
|b|2|

Related functions: [array](../a/array.md) and [dict](../d/dict.md)

