# matchSpan {#matchSpan}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`matchSpan(textCol, span, slop, \[scoreColName\])`

## Arguments {#arguments}

**textCol** is the column to be searched, i.e., the column with text indexing set in the PKEY engine.

**span**is a STRING scalar specifying the phrase to search for, which is order-sensitive.

**slop** is a non-negative integer specifying the number of extra words allowed before, after, or within the specified phrase.

**scoreColName** \(optional\) is a STRING scalar specifying the column name of the text matching score in the output. The default value is null, which means no score column is output. The matching score indicates the degree of matching within a partition; scores across different partitions are not comparable.

## Details {#details}

Perform flexible text searches on the column with text indexing set in the PKEY engine. This function is used in the `where` clause of a SQL statement.

**Return value**: Rows containing the specified phrase with no more than *slop* extra words \(excluding stop words\) before, after, or within it.

## Examples {#examples}

``` {#codeblock_mgc_ylv_fdc}
// Generate data for queries
stringColumn = ["There are some apples and oranges.","Mike likes apples.","Alice likes oranges.","Mike gives Alice an apple.","Alice gives Mike an orange.","John likes peaches, so he does not give them to anyone.","Mike, can you give me some apples?","Alice, can you give me some oranges?","Mike traded an orange for an apple with Alice."]
t = table([1,1,1,2,2,2,3,3,3] as id1, [1,2,3,1,2,3,1,2,3] as id2, stringColumn as remark) 
if(existsDatabase("dfs://textDB")) dropDatabase("dfs://textDB")
db = database(directory="dfs://textDB", partitionType=VALUE, partitionScheme=[1,2,3], engine="PKEY")
pt = createPartitionedTable(dbHandle=db, table=t, tableName="pt", partitionColumns="id1",primaryKey=`id1`id2,indexes={"remark":"textindex(parser=english, lowercase=true, stem=true)"})
pt.tableInsert(t)

// Search for rows containing phrase "mike apple", allowing up to 3 extra words (excluding stop words) before, after, or within the phrase
select * from pt where matchSpan(remark, "mike apple", 2)
```

|id1|id2|remark|
|---|---|------|
|1|2|Mike likes apples.|
|2|1|Mike gives Alice an apple.|
|3|3|Mike traded an orange for an apple with Alice.|

