# mask {#mask}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`mask(X, Y)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix.

**Y** is a conditional expression that generates *true* or *false*.

## Details {#details}

Apply *Y* on each element of *X*. If the result is *false*, keep the element; if the result is *true*, change it to null. The result is of the same length as *X*.

## Examples {#examples}

```
x=1..10
mask(x, x>6);
// output: [1,2,3,4,5,6,,,,]

m=matrix(1 2 3, 4 5 6, 7 8 9);
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|4|7|
|2|5|8|
|3|6|9|

```
mask(m, m<6);
```

|\#0|\#1|\#2|
|---|---|---|
|||7|
|||8|
||6|9|

