# makeKey {#makekey}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`makeKey(args...)`

## Arguments {#arguments}

**args** are multiple scalars or vectors of the same length.

## Details {#details}

Combine the specified *args* as a BLOB scalar or vector, so it can used as the key\(s\) of a dictionary or a set. Compared with *makeSortedKey*, *makeKey* keeps the order of the inputs in the result.

## Examples {#examples}

```
makeKey(`a1,`b1,`c1)
// output: a1b1c1

set(makeKey(1 2, 4 5))

re=makeKey(`a1`a2, `_1`_2)
dict(re,100 200)

/* output:
a2_2->200
a1_1->100
*/
```

Related Function: [makeSortedKey](makeSortedKey.md)

