# mad {#mad}

## Syntax {#syntax}

`mad(X, [useMedian=false])`

## Arguments {#arguments}

**X** is a vector, matrix or table.

**useMedian** is a Boolean value indicating whether the result is generated with the median absolute deviation or the mean absolute deviation. The default value is false and it returns the mean absolute deviation.

-   Mean Absolute Deviation: mean\(abs\(X - mean\(X\)\)\)

-   Median Absolute Deviation: med\(abs\(X - med\(X\)\)\)


## Details {#details}

If *X* is a vector, return the average absolute deviation of *X*.

If *X* is a matrix, the calculation is based on each column and returns a matrix.

If *X* is a table, the calculation is based on each column and returns a table.

As with all aggregate functions, null values are not included in the calculation.

## Examples {#examples}

```
mad([85, 90, 95, NULL]);
// output: 3.333333333333333

m=matrix(85 90 95, 185 190 195);
m;
```

|\#0|\#1|
|---|---|
|85|185|
|90|190|
|95|195|

```
mad m;
// output: [3.333333333333333, 3.333333333333333]

mad([0, 19.618568, 67.900707, 71.65218, 73.103952, 58.275308, 18.819054, 36.940571, 48.114366], false)
// output: 22.204817
```

Related function: [mmad](mmad.md)

