# lu {#lu}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`lu(obj, [permute=false])`

## Arguments {#arguments}

**obj** is a matrix with no null values.

**permute** is a Boolean value. The default value is false.

## Details {#details}

Compute pivoted LU decomposition of a matrix.

If *permute* is false, return 3 matrices \(L, U and P\) with *obj* = P'*L*U. P is a permutation matrix, L is a lower triangular matrix with unit diagonal elements, and U is an upper triangular matrix.

If *permute* is true, return 2 matrices \(L and U\) with *obj* = L\*U.

## Examples {#examples}

```
A = matrix([[2, 5, 8, 7], [5, 2, 2, 8], [7, 5, 6, 6], [5, 4, 4, 8]]);

P, L, U = lu(A);
P;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|0|0|1|0|
|0|0|0|1|
|1|0|0|0|
|0|1|0|0|

```
L;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|0|0|0|
|0.875|1|0|0|
|0.25|0.72|1|0|
|0.625|0.12|0.233871|1|

```
U;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|8|2|6|4|
|0|6.25|0.75|4.5|
|0|0|4.96|0.76|
|0|0|0|0.782258|

```
L, U = lu(A, true);
L;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|0.25|0.72|1|0|
|0.625|0.12|0.233871|1|
|1|0|0|0|
|0.875|1|0|0|

```
U;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|8|2|6|4|
|0|6.25|0.75|4.5|
|0|0|4.96|0.76|
|0|0|0|0.782258|

