# lt {#lt}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`lt(X, Y)` or `X<Y`

## Arguments {#arguments}

**X** / **Y** is a scalar/pair/vector/matrix/set. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

If neither *X* nor *Y* is a set, return the element-by-element comparison of *X*&lt;*Y*.

If both *X* and *Y* are sets, check if *X* is a proper subset of *Y*.

## Examples {#examples}

```
1 2 3 < 2;
// output: [1,0,0]

1 2 3<0 2 4;
// output: [0,0,1]

2:3<1:6;
// output: 0 : 1

m1=1..6$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
m1 lt 4;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|1|0|0|

```
m2=6..1$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1<m2;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|0|
|1|0|0|

Set operation: If *X*&lt;*Y* then *X* is a proper subset of *Y*

```
x=set(4 6);
x;
// output: set(6,4)

y=set(8 9 4 6);
y;
// output: set(6,4,9,8)

x<y;
// output: 1

y<x;
// output: 0

x<x;
// output: 0
// x is not a proper subset of x
```

