# lshift {#lshift}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`lshift(X,bits)` or `X<<bits`

## Arguments {#arguments}

**X** is an integral scalar/pair/vector/matrix/table.

**bits** is the number of bits to shift.

## Details {#details}

Shift the binary representation of *X* to the left by *bits*. The bits on the right are filled with zeros.

## Examples {#examples}

```
lshift(2, 10);
// output: 2048

1..10 << 1;
// output: [2,4,6,8,10,12,14,16,18,20]

1..10 << 10;
// output: [1024,2048,3072,4096,5120,6144,7168,8192,9216,10240]

1:10<<10;
// output: 1024 : 10240
```

Related function: [rshift](../r/rshift.md).

