# lpad {#lpad}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`lpad(str, length, [pattern])`

## Arguments {#arguments}

**str** is a STRING scalar/vector, or table. It is the string to pad characters to \(the left-hand side\).

**length** is a positive integer indicating the number of characters to return. If *length* is smaller than the length of *str*, the *lpad* function is equivalent to `left(str, length)`.

**pattern** is a string scalar. It is the string that will be padded to the left-hand side of *str*. If it is unspecified, the *lpad* function will pad spaces to the left-side of *str*.

## Details {#details}

Pad the left-side of a string with a specific set of characters.

If *str* is a table, the function is applied only to columns of STRING type. Other column types are ignored.

## Examples {#examples}

```
lpad("Hello",2);
// output: He

lpad(`Hello, 10);
/* output:
     Hello
*/

lpad(`Hello, 12, `0);
// output: 0000000Hello
```

