# lowRange {#lowrange}

## Syntax {#syntax}

`lowRange(X)`

## Arguments {#arguments}

**X** is a vector/tuple/matrix/table.

## Details {#details}

For each element *Xi* in *X*, count the continuous nearest neighbors to its left that are larger than *Xi*.

For each element in *X*, the function return the maximum length of a window to the left of *X* where it is the max/min. For example, after how many days a stock hits a new high.

## Examples {#examples}

```
lowRange([13.5, 13.6, 13.4, 13.3, 13.5, 13.9, 13.1, 20.1, 20.2, 20.3])
// output: [0,0,2,3,0,0,6,0,0,0]

m = matrix(1.5 2.6 3.2 1.4 2.5 2.2 3.7 2.0, 1.6 2.3 4.2 5.6 4.1 3.2 4.4 6.9)
lowRange(m)
```

|\#0|\#1|
|---|---|
|0|0|
|0|0|
|0|0|
|3|0|
|0|2|
|1|3|
|0|0|
|3|0|

```
//Simulate the stock price of stock A for 8 days. Use lowRange to calculate after how many days the stock hit a new low
trades = table(take(`A, 8) as sym,  2022.01.01 + 1..8 as date, 39.70 39.72 39.80 39.78 39.83 39.92 40.00 40.03 as price)
select *, lowRange(price) from trades
```

|id|date|price|lowRange\_price|
|---|----|-----|---------------|
|A|2022.01.02|39.7|0|
|A|2022.01.03|39.72|0|
|A|2022.01.04|39.8|0|
|A|2022.01.05|39.78|1|
|A|2022.01.06|39.83|0|
|A|2022.01.07|39.92|0|
|A|2022.01.08|40|0|
|A|2022.01.09|40.03|0|

Related function: [topRange](../t/topRange.md)

