# logout {#logout}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`logout([userId], [sessionOnly=true])`

## Arguments {#arguments}

**userId** is a string indicating a user name. It can only contain letters, underscores, or numbers. It cannot start with numbers. Its length cannot exceed 30 characters.

**sessionOnly** is a Boolean value.

## Details {#details}

This function can be executed on a controller/data/compute node.

If *userId* is unspecified, the current user logs out.

If *sessionOnly* is true, the user logs out from the current session.

If *sessionOnly* is false, the user logs out completely from the current session, all data/compute nodes, and the controller node.

An administrator can log out another user. If an administrator logs out another user, the user is logged out from the current session, all data nodes, and the controller node.

## Examples {#examples}

```
logout();

logout(`TomFord);

logout(, false);
```

