# loess {#loess}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loess(X, Y, resampleRule, [closed='left'], [origin='start_day'], [outputX=false], [bandwidth=0.3], [robustnessIter=4], [accuracy=1e-12])`

## Arguments {#arguments}

**X** is a strictly increasing vector of temporal type.

**Y** is a numeric vector of the same length as *X*.

**resampleRule** is a string. See the parameter *rule* of function [resample](../r/resample.md) for the optional values.

**closed** and **origin** are the same as the parameters *closed* and *origin* of function [resample](../r/resample.md).

**outputX** is a Boolean value indicating whether to output the resampled X. The default value is false.

**bandwidth** is a numeric scalar in \(0,1\]. when computing the loess fit at a particular point, this fraction of source points closest to the current point is taken into account for computing a least-squares regression.

**robustnessIter** is a postive interger indicating how many robustness iterations are done.

**accuracy** is a number greater than 1. If the median residual at a certain robustness iteration is less than this amount, no more iterations are done.

## Details {#details}

Resample *X* based on the specified *resampleRule*, *closed* and *origin*. Implement Local Regression Algorithm \(Loess\) for interpolation on *Y* based on the resampled *X*.

If *outputX* is unspecified, return a vector of *Y* after the interpolation.

If *outputX*=true, return a tuple where the first element is the vector of resampled *X* and the second element is a vector of *Y* after the interpolation.

## Examples {#examples}

```
loess([2016.02.14 00:00:00, 2016.02.15 00:00:00, 2016.02.16 00:00:00], [1.0, 2.0, 4.0], resampleRule=`60min, bandwidth=1)

/* output:
[1,1.0521,1.104,1.1558,1.2072,1.2582,1.3086,1.3584,1.4074,1.4556,
1.5027,1.5488,1.5937,1.6374,1.6795,1.7202,1.7593,1.7966,1.832,1.8655,
1.897,1.9263,1.9533,1.9779,2,2.0195,2.0366,2.0513,2.0637,2.0739,
2.082,2.0882,2.0926,2.0952,2.0962,2.0957,2.0938,2.0905,2.0861,2.0806,
2.0741,2.0667,2.0586,2.0498,2.0405,2.0308,2.0207,2.0104,2]
*/
```

