# loadPlugin {#loadplugin}

## Syntax {#syntax}

`loadPlugin(metaFile)`

## Arguments {#arguments}

**metaFile** is the absolute path of a text file that describes a DolphinDB plugin. Since version 2.00.11/1.30.23, it can be specified as the plugin name \(case sensitive\). The system will load the plugin through the plugin name and the configuration parameter *pluginDir*. Note that the name of a very small number of plugins differs from the name of the folder where it is located. In such cases, loading the plugin through the plugin name will fail due to the non-existent path. To resolve this, modify *metaFile* to the folder name.

## Details {#details}

Load a plugin into DolphinDB. It must be executed by a logged-in user. Note that for DolphinDB community edition users, paid plugins must be purchased separately.

For each DolphinDB plugin, there is a text file that describes the plugin. The first line of the text file includes the names of the plugin and the shared library file, separated by comma ",". Each of the following lines includes the following information: a function in the library file, the corresponding DolphinDB function, function type \(operator or system function\), the minimal number of parameters, the maximum number of parameters, whether the function is an aggregate function, whether the function is order-sensitive or not.

The function returns a tuple with the names of the functions in the library file.

## Examples {#examples}

-   Load the plugin from the Plugin Square

    Take the MQTT plugin as an example. After installing the plugin with`installPlugin`, the plugin can be loaded in two ways:

    -   Load the plugin using the absolute path:

        ``` {#codeblock_vwd_1tx_l1c}
        installPlugin("mqtt")
        loadPlugin("D:/TEST/DolphinDB_Win64_V2.00.10/server/plugins/mqtt/PluginMQTT.txt")
        ```

    **Note**: When loading a plugin with the absolute path on Windows, make sure to use "/" in the path, instead of "\\".

    -   Load the plugin by specifying its name:

        ``` {#codeblock_pjv_1tx_l1c}
        installPlugin("mqtt")
        loadPlugin("mqtt")
        ```

-   Load the manually compiled plugin

    The file *odbc.txt* of the DolphinDB odbc plugin:

    ``` {#codeblock_df2_dwt_hzb}
    odbc,libPluginODBC.so,2.00.10
    odbcQuery,query,system,2,5,0
    odbcConnect,connect,system,1,2,0
    odbcClose,close,system,1,1,0
    odbcExecute,execute,system,2,2,0
    odbcAppend,append,system,3,5,0
    ```

    The odbc plugin provides 5 methods, `query`, `connect`, `close`, `execute`, and `append`. Install the plugin to use these methods. The following script shows how to load the odbc plugin and call its methods:

    ``` {#codeblock_psh_dy1_b1c}
    loadPlugin("/home/DolphinDB/server/plugins/odbc/odbc.txt")
    // Or you can use plugin name to load the plugin.
    loadPlugin("odbc")
    use odbc
    ConnStr="Driver=MySQL;Data Source=odbc_test;Server=127.0.0.1;Uid=root;Pwd=123456;Database=odbc_test"
    conn=connect(connStr)      // create connection to MySQL
    
    t=query(conn,"select * from test")
    close(conn)
    ```


