# loadNpz {#loadnpz}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loadNpz(fileName)`

## Arguments {#arguments}

**filename** is a STRING indicating the path of *.npz* file.

## Details {#details}

Read an npz binary file from Python NumPy and convert it into DolphinDB objects. NaN in *.npz* file is converted into null values in DolphinDB.

Conversion Table for Python np.array and DolphinDB Objects:

|NumPy array|DolphinDB Objects|
|-----------|-----------------|
|one-dimensional|vector|
|two-dimensional|matrix|
|three-dimensional|tuple \(where each element represents a matrix|

Data types supported for conversion are: BOOL, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE and STRING \(only one-dimensional array is supported\).

## Examples {#examples}

Save *.npz* file in Python:

```python
import numpy as np
a = np.array([[[97, 98]]], dtype=np.int8)
a1 = np.array(['133', '211', '3dds', 'ddd4', 'e5', 'w6'])
b1 = np.array([[0.7, 0.8, 9.2], [0, np.nan, np.nan], [1.5, 2.8, 0.2]])
c1 = np.array([[[0.2, 3.3], [1.9, 4.3]], [[5, 6], [1, 2]]])
np.savez('my_path/array_save.npz', char=a, a1=a1, b1=b1, c1=c1)
```

Load *.npz* file in DolphinDB:

```
path="my_path/array_save.npz"
loadNpz(path)
/* output:
a1->[133,211,3dds,ddd4,e5,w6]
char->(#0  #1
'a' 'b'
)
c1->(#0  #1
0.2 3.3
1.9 4.3
,#0 #1
5  6
1  2
)
b1->
#0  #1  #2
0.7 0.8 9.2
0
1.5 2.8 0.2
*/
```

Related Function: [loadNpy](loadNpy.md)

