# loadNpy {#loadnpy}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loadNpy(fileName)`

## Arguments {#arguments}

**filename** is a string indicating the path and name of an *.npy* file.

## Details {#details}

Load an *.npy* \(Python Numpy\) binary file and convert it into a DolphinDB vector or matrix. NaN in the *.npy* file is converted into null values in DolphinDB.

Right now the function only works for *.npy* files with numerical data.

## Examples {#examples}

Save *.npy* files in Python:

```python
import numpy as np
np.save("intVec.npy", np.array([5,6,1,3,4,8]))
np.save("doubleMat.npy", np.array([[1.5,5.6,-7.87],[-1.0,3.4,4.5]]))
```

Load *.npy* files in DolphinDB:

```
loadNpy("intVec.npy");
// output: [5,6,1,3,4,8]

loadNpy("doubleMat.npy");
```

|\#0|\#1|\#2|
|---|---|---|
|1.5|5.6|-7.87|
|-1|3.4|4.5|

Related function: [saveAsNpy](../s/saveAsNpy.md)

