# loadModel {#loadmodel}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loadModel(file)`

## Arguments {#arguments}

**file** is a string indicating the absolute path and name of the output file.

## Details {#details}

Load the specifications of a trained model into memory as a dictionary.

## Examples {#examples}

```
x1 = rand(100.0, 100)
x2 = rand(100.0, 100)
b0 = 6
b1 = 1
b2 = -2
err = norm(0, 10, 100)
y = b0 + b1 * x1 + b2 * x2 + err
t = table(x1, x2, y)
model = randomForestRegressor(sqlDS(<select * from t>), `y, `x1`x2)
saveModel(model, "C:/DolphinDB/Data/regressionModel.txt");

model = loadModel("C:/DolphinDB/Data/regressionModel.txt")
yhat = predict(model, t);
```

