# loadBackup {#loadbackup}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loadBackup(backupDir, dbPath, partition, tableName)`

## Arguments {#arguments}

**backupDir** is a string indicating the directory where the backup is saved.

**dbPath** is a string indicating the path of a DFS database. For example: "dfs://demo".

**partition** is a string indicating the path of a partition under the database. For example: "/20190101/GOOG".

**Note:**

For versions between 1.30.16/2.00.4 -1.30.18/2.00.6, if *chunkGranularity* is set to "TABLE" when creating the database, *partition* must include the physical index \(which you can get with the `listTables` function\) of the selected partition. For example, if the physical index of the "/20190101/GOOG" partition is 8, then specify partition as "/20190101/GOOG/8" to load its backup.

**tableName** is a string indicating a distributed table name.

## Details {#details}

Load the backup of a partition in a distributed table. It must be executed by a logged-in user.

Currently, this function only supports loading a partition backed up with SQL statement \(when the parameter *sqlObj* is specified for function [backup](../b/backup.md)\).

## Examples {#examples}

```
loadBackup("/home/DolphinDB/backup","dfs://valuedb", "/200001M","pt");
```

|month|x|
|-----|---|
|2000.01M|1|
|2000.01M|205|
|2000.01M|409|
|2000.01M|613|
|2000.01M|817|

