# listPluginsByCluster {#listPluginsByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`listPluginsByCluster(clusterName)`

## Arguments {#arguments}

**clusterName** is a STRING scalar indicating the name of the cluster.

## Details {#details}

Get the installation status of plugins on each node in the specified cluster. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A table with the following columns:

-   plugin: Name of the plugin.
-   version: Version of the plugin.
-   user: Name of the user who installed the plugin.
-   time: Installation time in milliseconds.
-   node: Name of the node where the plugin is installed.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
// MoMSender cluster:
installPlugin("mysql")
loadPlugin("mysql")
  
// MoM cluster:
listPluginsByCluster("MoMSender")
  
```

|plugin|version|user|time|node|
|------|-------|----|----|----|
|mysql|3.00.3|admin|2025.05.24T17:10:42.300|dnode1|
|zip|3.00.3|admin|2025.05.24T17:10:42.285|dnode1|
|mysql|3.00.1.3|admin|2025.05.24T17:10:49.135|controller8899|
|zip|3.00.3|admin|2025.05.24T17:10:49.120|controller8899|

