# like {#like}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`like(X, pattern)`

## Arguments {#arguments}

**X** is a string scalar/vector.

**pattern** is a string and is usually used with a wildcard character such as %.

## Details {#details}

Return a Boolean value scalar or vector indicating whether each element in *X* fits a specific pattern. The comparison is case sensitive.

## Examples {#examples}

```
like(`ABCDEFG, `DE);
// output: false

like(`ABCDEFG, "%DE%");
// output: true

a=`IBM`ibm`MSFT`Goog`YHOO`ORCL;
like(a, "%OO%");
// output: [false,false,false,false,true,false]

a[like(a, "%OO%")];
// output: ["YHOO"]
```

`like` can be used with SQL SELECT to filter columns of STRING type:

``` {#codeblock_s2j_5ft_hzb}
t = table(`abb`aac`aaa as sym, 1.8 2.3 3.7 as price);
select * from t where sym like "%aa%";
```

|sym|price|
|---|-----|
|aac|2.3|
|aaa|3.7|

Related function: [ilike](../i/ilike.md)

