# license {#license}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`license([fileName], [pubKeyFile], [read=false])`

## Arguments {#arguments}

**fileName** \(optional\) is the path of the license.

**pubKeyFile** \(optional\) is the path of the public key file.

**read** \(optional\) is a Boolean value indicating whether to disable the license file verification before returning the result. The default value is false.

## Details {#details}

Display information regarding the DolphinDB license. If *fileName* is not specified, the license information from memory is obtained by default.

It returns a dictionary with the following keys:

<table><thead><tr><th align="left">

Keys

</th><th align="left">

Meaning

</th></tr></thead><tbody><tr><td align="left">

authorization

</td><td align="left">

authorization types: trial/test/commercial

</td></tr><tr><td align="left">

licenseType

</td><td align="left">

The license type: -   1: fingerprint authentication;
-   2: online verification;
-   3: license server;
-   0: others

</td></tr><tr><td align="left">

maxMemoryPerNode

</td><td align="left">

the maximum memory for each node \(in GB\)

</td></tr><tr><td align="left">

bindCores

</td><td align="left">

CPU ID\(s\) \(starting from 0\) that are already bound to the DolphinDB process. Note that it takes effect only when bindCPU is configured to true.

</td></tr><tr><td align="left">

maxCoresPerNode

</td><td align="left">

the maximum cores for each node

</td></tr><tr><td align="left">

clientName

</td><td align="left">

the client name

</td></tr><tr><td align="left">

port

</td><td align="left">

the port number bound to the node. It is returned only for the license server and its connected nodes.

</td></tr><tr><td align="left">

bindCPU

</td><td align="left">

whether a DolphinDB process is bound to a CPU

</td></tr><tr><td align="left">

expiration

</td><td align="left">

the expiration date of the license

</td></tr><tr><td align="left">

maxNodes

</td><td align="left">

the maximum number of nodes for the cluster

</td></tr><tr><td align="left">

version

</td><td align="left">

the version number of the server. Only a server that is not higher than the version can be used. If it is empty, there is no restriction on the version.

</td></tr><tr><td align="left">

modules

</td><td align="left">

a decimal converted from 4-bit binary number, indicating the supported modules.

</td></tr><tr><td align="left">

moduleNames

</td><td align="left">

names of supported *modules*. Currently, only *orderbook*, *internalFunction*, *cep*, *gpu*, *starfish*, *Beluga*, *Backtest*, *MatchingEngineSimulator* will be returned.

</td></tr><tr><td align="left">

productKey

</td><td align="left">

the current product. The return value includes DOLPHIN, IOTBASIC, IOTPRO, SHARK, SWORDFISH, ORCA, DOLPHINX.

</td></tr></tbody>
</table>## Examples {#examples}

```python
license();
/* output
clientName->internal
bindCPU->true
maxNodes->128
moduleNames-> orderbook internalFunction cep gpu
productKey->DOLPHIN
version->3.10
modules->15
authorization->trial
maxMemoryPerNode->512
licenseType->0
bindCores->
maxCoresPerNode->128
port->0
expiration->2024.09.30
*/
```

