# lfill {#lfill}

## Syntax {#syntax}

`lfill(obj)`

## Arguments {#arguments}

**obj** is a vector or a table with only numeric columns.

## Details {#details}

-   If *obj* is a vector: linearly fill the null values between 2 non-null numeric values in *obj*.

-   If *obj* is a table with only numeric columns: for each column of the table, linearly fill the null values between 2 non-null numeric values.


*lfill* does not change *obj*, whereas *lfill!* changes *obj*.

## Examples {#examples}

```
a= NULL 1.5 NULL NULL 4.5
a.lfill();
// output: [NULL,1.5,2.5,3.5,4.5]

b=1 NULL NULL 6
b.lfill();
// output: [1,3,4,6]

t=table(1 NULL NULL 4 5 6 as id,2.1 2.2 NULL NULL 2.4 2.6 as val);
select * from lfill(t);
```

|id|val|
|---|---|
|1|2.1|
|2|2.2|
|3|2.266667|
|4|2.333333|
|5|2.4|
|6|2.6|

Related functions: [bfill](../b/bfill.md), [bfill!](../b/bfill!.md), [lfill!](lfill!.md)

