# lfill! {#lfill}

## Syntax {#syntax}

`lfill!(obj)`

## Arguments {#arguments}

**obj** is a vector or a table with only numeric columns.

## Details {#details}

Please refer to [lfill](lfill.md). The only difference between *lfill* and *lfill!* is that the latter assigns the result to *X* and thus changing the value of *X* after the execution.

## Examples {#examples}

``` {#codeblock_c2n_hct_hzb}
a= NULL 1.5 NULL NULL 4.5
a.lfill!()
a;
[NULL,1.5,2.5,3.5,4.5]

b=1 NULL NULL 6
b.lfill!()
b;
[1,3,4,6]

t=table(1 NULL NULL 4 5 6 as id,2.1 2.2 NULL NULL 2.4 2.6 as val);
lfill!(t);
t;
```

|id|val|
|---|---|
|1|2.1|
|2|2.2|
|3|2.266667|
|4|2.333333|
|5|2.4|
|6|2.6|

Related functions: [bfill](../b/bfill.md), [bfill!](../b/bfill!.md), [lfill!](lfill!.md)

