# latestKeyedTable {#latestkeyedtable}

## Syntax {#section_ztf_4f1_dzb .section}

`latestKeyedTable(keyColumns, timeColumn, [X1], [X2], .....)`

or

`latestKeyedTable(keyColumns, timeColumn, capacity:size, colNames, colTypes)`

or

`latestKeyedTable(keyColumns, timeColumn, table)`

## Arguments {#section_fzl_yf1_dzb .section}

Compared to the [keyedTable](../k/keyedTable.md) function, `latestKeyedTable` includes an additional parameter called *timeColumn* to specify the temporal dimension of the data.

**timeColumn** is a string that specifies the name of the time column which can be either of integral or temporal data type.

## Details {#section_chm_zf1_dzb .section}

Create a keyed table, which is a special type of in-memory table with primary key. The primary key can be one column or multiple columns. Compared to the `keyedTable`, `latestKeyedTable` adds a time column to determine whether to update records.

When a new record is appended to the keyed table, if its timestamp is smaller than that of the existing row which has the same primary key, it does not overwrite the existing row. `latestKeyedTable` deduplicates records with the same primary key based on the time column, which affects its writing performance \(relatively slow compared with `keyedTable`\).

**Note:** The primary key cannot be modified \(with functions `update`, or `replaceColumn!`\) or deleted \(with functions `alter`, or `dropColumns!`\).

Refer to `keyedTable` for the optimization of query performance on `latestKeyedTable`.

## Examples {#section_wp4_bg1_dzb .section}

Example 1. Create a keyed table.

Scenario 1:

``` {#codeblock_emj_cg1_dzb}
sym=`A`B`C`D`E
id=5 4 3 2 1
val=52 64 25 48 71
timeCol = 2022.12.07T00:00:00.001+0..4
t=latestKeyedTable(`sym`id,`timeCol,sym,id,timeCol,val)
t;
    
```

|sym|id|timeCol|val|
|---|---|-------|---|
|A|5|2022.12.07T00:00:00.001|52|
|B|4|2022.12.07T00:00:00.002|64|
|C|3|2022.12.07T00:00:00.003|25|
|D|2|2022.12.07T00:00:00.004|48|
|E|1|2022.12.07T00:00:00.005|71|

Scenario 2:

``` {#codeblock_gmj_cg1_dzb}
t=latestKeyedTable(`sym`id,`timeCol, 1:0,`sym`id`timeCol`val,[SYMBOL,INT,TIMESTAMP, INT])
insert into t values(`A`B`C`D`E,5 4 3 2 1,2022.12.07T00:00:00.001+0..4,52 64 25 48 71);
```

Scenario 3:

``` {#codeblock_hmj_cg1_dzb}
tmp=table(sym, id, timeCol, val)
t=latestKeyedTable(`sym`id, `timeCol, tmp);
```

Example 2. Update a keyed table.

If the new row has the same primary key value as an existing row, whether to update the record is determined by the time column.

``` {#codeblock_imj_cg1_dzb}
insert into t values(`A`A`E,5 5 1, 2022.12.07T00:00:00.001 2022.12.07T00:00:00.007 2022.12.07T00:00:00.003, 44 66 28);
 t;
```

|sym|id|timeCol|val|
|---|---|-------|---|
|A|5|2022.12.07T00:00:00.007|66|
|B|4|2022.12.07T00:00:00.002|64|
|C|3|2022.12.07T00:00:00.003|25|
|D|2|2022.12.07T00:00:00.004|48|
|E|1|2022.12.07T00:00:00.005|71|

Related functions: [keyedTable](../k/keyedTable.md), [indexedTable](../i/indexedTable.md), [latestIndexedTable](latestIndexedTable.md)

**Parent topic:**[Functions](../../Functions/category.md)

