# latestIndexedTable {#latestindexedtable}

## Syntax {#section_jft_gf1_dzb .section}

`latestIndexedTable(keyColumns, timeColumn, [X1], [X2], .....)`

or

`latestIndexedTable(keyColumns, timeColumn, capacity:size, colNames, colTypes)`

or

`latestIndexedTable(keyColumns, timeColumn, table)`

## Arguments {#section_yfr_hf1_dzb .section}

Compared to the [indexedTable](../i/indexedTable.md) function, `latestIndexedTable` includes an additional parameter called *timeColumn* to specify the temporal dimension of the data.

**timeColumn** is a string that specifies the name of the time column which can be either of integral or temporal data type.

## Details {#section_lbv_3f1_dzb .section}

Create an indexed table, which is a special type of in-memory table with primary key. The primary key can be one column or multiple columns. Compared to the `indexedTable`, `latestIndexedTable` adds a time column to determine whether to update records.

When a new record is appended to the indexed table, if its timestamp is smaller than that of the existing row which has the same primary key, it does not overwrite the existing row. `latestIndexedTable` deduplicates records with the same primary key based on the time column, which affects its writing performance \(relatively slow compared with `indexedTable`\).

**Note:** The primary key cannot be updated.

Refer to `indexedTable` for the optimization of query performance on `latestIndexedTable`.

## Examples {#section_k32_lf1_dzb .section}

Example 1. Create an indexed table.

Scenario 1:

``` {#codeblock_i2d_nf1_dzb}
sym=`A`B`C`D`E
id=5 4 3 2 1
val=52 64 25 48 71
timeCol = 2022.12.07T00:00:00.001+0..4
t=latestIndexedTable(`sym`id,`timeCol,sym,id,timeCol,val)
t;
```

|sym|id|timeCol|val|
|---|---|-------|---|
|A|5|2022.12.07T00:00:00.001|52|
|B|4|2022.12.07T00:00:00.002|64|
|C|3|2022.12.07T00:00:00.003|25|
|D|2|2022.12.07T00:00:00.004|48|
|E|1|2022.12.07T00:00:00.005|71|

Scenario 2:

``` {#codeblock_k2d_nf1_dzb}
t=latestIndexedTable(`sym`id,`timeCol, 1:0,`sym`id`timeCol`val,[SYMBOL,INT,TIMESTAMP, INT])
insert into t values(`A`B`C`D`E,5 4 3 2 1,2022.12.07T00:00:00.001+0..4,52 64 25 48 71);
```

Scenario 3:

``` {#codeblock_l2d_nf1_dzb}
tmp=table(sym, id, timeCol, val)
t=latestIndexedTable(`sym`id, `timeCol, tmp);
```

Example 2. Update an indexed table.

If the new row has the same primary key value as an existing row, whether to update the record is determined by the time column.

``` {#codeblock_m2d_nf1_dzb}
insert into t values(`A`A`E,5 5 1, 2022.12.07T00:00:00.001 2022.12.07T00:00:00.007 2022.12.07T00:00:00.003, 44 66 28);
t;
```

|sym|id|timeCol|val|
|---|---|-------|---|
|A|5|2022.12.07T00:00:00.007|66|
|B|4|2022.12.07T00:00:00.002|64|
|C|3|2022.12.07T00:00:00.003|25|
|D|2|2022.12.07T00:00:00.004|48|
|E|1|2022.12.07T00:00:00.005|71|

Related functions: [keyedTable](../k/keyedTable.md), [indexedTable](../i/indexedTable.md), [latestKeyedTable](latestKeyedTable.md)

**Parent topic:**[Functions](../../Functions/category.md)

