# lastNot {#lastnot}

## Syntax {#syntax}

`lastNot(X, [k])`

## Arguments {#arguments}

**X** is a vector, a matrix or a table.

**k** \(optional\) is a scalar.

## Details {#details}

If *X* is a vector:

-   If *k* is not specified: return the last element of *X* that is not null.

-   If *k* is specified: return the last element of *X* that is neither *k* nor null.


If *X* is a matrix/table, conduct the aforementioned calculation within each column of *X*. The result is a vector.

`lastNot` also supports querying DFS tables and partitioned tables.

## Examples {#examples}

```
lastNot(1 6 0 0 0, 0);
// output: 6

lastNot(1 6 0 0 0 2 3 0 NULL, 0);
// output: 3

lastNot(1 6 0 0 0 2 3 0 NULL);
// output: 0

t=table(1 1 1 1 1 2 2 2 2 2 as id, 1 2 0 0 0 3 NULL NULL 0 0 as x);
t;
```

|id|x|
|---|---|
|1|1|
|1|2|
|1|0|
|1|0|
|1|0|
|2|3|
|2||
|2||
|2|0|
|2|0|

```
select lastNot(x, 0) from t group by id;
```

|id|lastNot\_x|
|---|----------|
|1|2|
|2|3|

```
m=matrix(2 NULL 1 0 NULL, NULL 2 NULL 6 0);
m;
```

|\#0|\#1|
|---|---|
|2|2|
|1||
|0|6 0|

```
lastNot(m, 0);
// output: [1,6]
```

