# ksTest {#kstest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ksTest(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric vectors indicating the samples for the test.

## Details {#details}

Conduct Kolmogorov-Smirnov test on *X* and *Y*.

-   ksValue: Kolmogorov-Smirnov statistic

-   pValue: p-value of the test

-   D: D-stat

-   method: "Two-sample Kolmogorov-Smirnov test"


## Examples {#examples}

```
x = norm(0.0, 1.0, 50)
y = norm(0.0, 1.0, 20)
ksTest(x, y);

/* output:
ksValue->0.739301
pValue->0.645199
D->0.19
method->Two-sample Kolmogorov-Smirnov test
*/
```

