# knn {#knn}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`knn(Y, X, type, nNeighbor, [power=2])`

## Arguments {#arguments}

**Y** is a vector with the same length as the number of rows of *X*. Each element is a label corresponding to each row in *X*.

**X** is a table. Each row is an observation and each column is a feature.

**type** is a string. It can be either "regressor" or "classifier".

**nNeighbor** is a positive integer indicating the number of nearest neighbors in training.

**power** is a positive integer indicating the parameter of Minkowski distance used in training. The default value is 2 indicating Euclidean distance. If *power*=1, it means Manhattan distance is used in training.

## Details {#details}

Implement the k-nearest neighbors \(k-NN\) algorithm with a brute-force search for classification and regression. Return a dictionary with the following keys:

-   nNeighbor: the number of nearest neighbors in training.

-   modelName: string "KNN".

-   model: the model to be saved.

-   power: the parameter of Minkowski distance used in training.

-   type: "regressor" or "classifier".


## Examples {#examples}

```
height = 158 158 158 160 160 163 163 160 163 165 165 165 168 168 168 170 170 170
weight = 58 59 63 59 60 60 61 64 64 61 62 65 62 63 66 63 64 68
t=table(height, weight)
labels=take(1,7) join take(2,11)
model = knn(labels,t,"classifier", 5);
```

