# kama {#kama}

## Syntax {#syntax}

`kama(X, window)`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Details {#details}

Calculate the Kaufman Adaptive Moving Average for *X* with a rolling *window*. The length of the window is given by the parameter *window*. The result is of the same length as *X*. The first \(*window*-1\) elements of the result are null values.

## Examples {#examples}

```
x=[51.65, 81.18, 43.37, 11.26, 82.79, 13.4, 81.87, 63.53, 21.28, 94.23]
kama(x, 5);
// output: [,,,,,81.006144,81.009907,80.793626,80.344572,80.456788]

t=table(take(`A`B,10) as sym, rand(100.0,10) as close)
select sym, kama(close, 3) as kama from t context by sym;
```

|sym|kama|
|---|----|
|A||
|A||
|A||
|A|66.342572|
|A|62.500023|
|B||
|B||
|B||
|B|17.376469|
|B|42.27882|

