# join! {#join}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`join!(X, Y)`

## Arguments {#arguments}

**X** is a vector/tuple/matrix/table.

**Y** is a scalar/vector/tuple/matrix/table.

If *X* is a vector, *Y* is a scalar/vector/tuple; if *X* is a matrix, *Y* is a vector/matrix; if *X* is a table, *Y* is a vector/table.

## Details {#details}

Merge *X* and *Y*, and assign the result to *X*. The resulting object has the same data type as *X*.

## Examples {#examples}

If *X* is a vector, *Y* must be a scalar, vector, or tuple whose elements all have the same data type as *X*. The result is a vector longer than *X*.

```
x=[1,2,3]
x.join!(4)
x;
// output: [1,2,3,4]

x.join!(5 6 7)
x;
// output: [1,2,3,4,5,6,7]

x.join!((8,9))
x;
// output: [1,2,3,4,5,6,7,8,9]
```

If *X* is a tuple, *Y* can be a scalar, vector or tuple. The result is a tuple longer than *X*.

```
x = (1,"A")
x.join!(2)
x;
// output: (1,"A",2)

x.join!([3,4,5])
x;
// output: (1,"A",2,[3,4,5])

x.join!(("B","C"))
x;
// when appendTupleAsAWhole = true
// output: (1,"A",2,[3,4,5],("B","C"))
// when appendTupleAsAWhole = false
// output: (1,"A",2,[3,4,5],"B","C")
```

If *X* is a matrix, *Y* must be a vector/matrix with the same number of rows as *X*. The result is a matrix with the same number of rows as *X*.

```
x=1..6$2:3
join!(x, [7,8])
x;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|3|5|7|
|2|4|6|8|

```
x.join!(9..12$2:2)
x;
```

|\#0|\#1|\#2|\#3|\#4|\#5|
|---|---|---|---|---|---|
|1|3|5|7|9|11|
|2|4|6|8|10|12|

If *X* is a table, *Y* must be a table or a vector with the same number of rows as *X*. The result is a table with the same number of rows as *X*.

```
a=table(1..3 as x, 4.5 6.7 8.5 as y);
a;
```

|x|y|
|---|---|
|1|4.5|
|2|6.7|
|3|8.5|

```
b=table(700 500 800 as z);
b;
```

|z|
|---|
|700|
|500|
|800|

```
join!(a,b);
a;
```

|x|y|z|
|---|---|---|
|1|4.5|700|
|2|6.7|500|
|3|8.5|800|

```
a=table(1..3 as x, `IBM`C`AAPL as y);
b=table(172.3 25 106.5 as z);
a.join!(b);
a;
```

|x|y|z|
|---|---|---|
|1|IBM|172.3|
|2|C|25|
|3|AAPL|106.5|

