# iterate {#iterate}

## Syntax {#syntax}

`iterate(init, coeffs, input)`

## Arguments {#arguments}

**init** a scalar or a vector.

**coeffs** a scalar or a vector. init and coeffs have the same length.

**input** a scalar or a vector. If *input* is a scalar, it must be an integer and it means the number of iterations; if *input* is a vector, its length means the number of iterations and each element of *input* is added to the result of the corresponding iteration.

## Details {#details}

If *init*, *coeffs* and *input* are all scalars, return a geometric sequence \[*init\*coeffs, init\*coeffs^2, init\*coeffs^3*, …\]. The length of the sequence is *input*.

If *init* and *coeffs* are scalars and *input* is a vector, return an array x with x\[0\]=`init*coeffs` + *input\[0\]* and x\[n\]=x\[n-1\]\* *coeffs* + *input\[n\]*.

If *init* and *coeffs* are vectors and *input* is a scalar, return an array x with x\[n\]=y\(n\)\*\* *coeffs*, y\(n\)=y\(n-1\)\[1:\].append!\(x\[n-1\]\), y\(0\)= *init*. The length of x is *input*. \*\* returns the inner product of 2 vectors.

If *init*, *coeffs* and *input* are all vectors, return an array x with x\[n\]=y\(n\)\*\* *coeffs* + *input\[n\]*, y\(n\)=y\(n-1\)\[1:\].append!\(x\[n-1\]\), y\(0\)= *init*. The length of x is *input*. \*\* returns the inner product of 2 vectors.

## Examples {#examples}

```
iterate(1, 0.8, 3);
// output: [0.8,0.64,0.512]
// 1*0.8=0.8, 0.8*0.8=0.64, 0.64*0.8=0.512

iterate(1, 0.8, 0.1 0.2 0.3);
// output: [0.9,0.92,1.036]
// 1*0.8+0.1=0.9, 0.9*0.8+0.2=0.92, 0.92*0.8+0.3=1.036

iterate(1 1, 1 1, 10);
// output: [2,3,5,8,13,21,34,55,89,144]
// this is the Fibonacci series: 1*1 + 1*1=2; 1*1+2*1=3; 2*1+3*1=5; 3*1+5*1=8; ... ; 55*1+89*1=144.

iterate(1 1, 1 1, 1 2 3 4 5);
// output: [3,6,12,22,39]
// 1*1+1*1+1=3; 1*1+3*1+2=6; 3*1+6*1+3=12; 6*1+12*1+4=22; 12*1+22*1+5=39.
```

