# isValley {#isvalley}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`isValley(X, [strict=true])`

## Arguments {#arguments}

**X** is a numeric vector/matrix/table.

**strict** is a Boolean value. For a segment of continuous identical numbers forming a local maximum \(referred to as a plateau\), the value of *strict*determines whether the entire plateau is considered a valley.

-   When *strict*= true, the plateau is not considered a valley, meaning all elements in the plateau return false.

-   When *strict*= false,

    -   If the number of elements in plateau is odd, the element at the middle will return true, while the others return false.

    -   If even, the element on the left side of the two middle elements will return true, while the others return false.


## Details {#details}

If *X* is a vector, check if each element in *X* is the valley.

If *X* is a matrix, perform the aforementioned calculations on each column and return a matrix of the same size as *X*.

If *X* is a table, only the numeric columns are involved in the calculations.

## Examples {#examples}

```
v = [3.1, 2.2, 2.2, 2.2, 1.3, 2.1, 1.2]
isValley(v)
// output: [false,false,false,false,true,false,false]

v = [3.1, 2.2, 2.2, 2.2, 2.6, 1, 1.2]
isValley(v)
// output: [false,false,false,false,false,true,false]

isValley(v, false)
// output: [false,false,true,false,false,true,false]

// Perform the calculations on each column in a matrix
m = matrix(5.3 5.8 5.6 NULL 5.7 1.2, 4.5 3.5 4.6 2.8 3.9 NULL)
isValley(m)
```

|\#0|\#1|
|---|---|
|false|false|
|false|true|
|false|false|
|false|true|
|false|false|
|false|false|

```
// Perform the calculations on the numeric columns in a table
t = table(`01`01`00`01`02`00 as id, 2022.01.01 + 1..6 as date, 388.3 390.6 390.8 390.6 390.3 391.5 as price)
isValley(t)
```

|id|date|price|
|---|----|-----|
|01|false|false|
|01|false|false|
|00|false|false|
|01|false|false|
|02|false|true|
|00|false|false|

Related function: [isPeak](isPeak.md)

