# isColumnarTuple {#iscolumnartuple}

## Syntax {#section_p4r_2q1_dzb .section}

`isColumnarTuple(X)`

## Arguments {#section_fsm_fq1_dzb .section}

**X** is a tuple.

## Details {#section_m2c_gq1_dzb .section}

Check if *X* is a columnar tuple.

## Examples {#section_dgp_gq1_dzb .section}

``` {#codeblock_uzm_hq1_dzb}
tp = [[1,2,3], [4,5,6], [7,8]]
isColumnarTuple(tp)
// output: false

tp.setColumnarTuple!()
isColumnarTuple(tp)
// output: true
```

``` {#codeblock_vzm_hq1_dzb}
id = 3 2 1 4
val = [`aa`bb, `aa`cc`dd, `bb, `cc`dd]
t = table(id, val)

isColumnarTuple(t.val)
// output: true

isColumnarTuple(t.id)
// output: false

exec isColumnarTuple(val) from t
// output: true

av = array(INT[], 0, 10).append!([1 1 1 3, 2 4 2 5, 8 9 7 1, 5 4 3])
t = table(id, av)
isColumnarTuple(t.av)
// output: false
```

**Parent topic:**[Functions](../../Functions/category.md)

