# interpolate {#interpolate}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`interpolate(X, [method='linear'], [limit], [inplace=false], [limitDirection='forward'], [limitArea], [index])`

## Arguments {#arguments}

**X** is a numeric vector.

**method** \(optional\) is a string indicating how to fill the null values. It can take the following values and the default value is 'linear'.

-   linear: for null values surrounded by valid values, fill the null values linearly. For null values outside valid values, fill the null values with the closest valid values.

-   pad: fill null values with existing values.

-   nearest: fill null values with the closest valid values.

    **Note:** When *method* = 'nearest' and *limitDirection =* 'both', if a null value is equidistant from nearest valid values on both sides, the system fills it using the value on the **left**.

-   krogh: fill null values with krogh polynomials.


**limit** \(optional\) is a positive integer indicating the maximum number of consecutive null values to fill.

**inplace** \(optional\) is a Boolean value indicating whether to update the input vector array. The default value is false, which means a new vector will be returned.

**limitDirection** \(optional\) is a string indicating the direction to fill null values. It can take the following values: 'forward', 'backward' and 'both'. The default value is 'forward'.

**limitArea** \(optional\) is a string indicating restrictions regarding filling null values. It can take the following values and the default value is empty string "".

-   empty string: no restrictions.

-   inside: only fill null values surrounded by valid values.

-   outside: only fill null values outside valid values.


**index** \(optional\) specifies a numeric or temporal vector that must have the same length as *X* and cannot contain null values. When *index* is provided, the function performs interpolation using these values as x-coordinates and *X* as y-coordinates to fill in any missing values in X.

## Details {#details}

Fills in null values in a numeric vector using interpolation. By default, the function treats each element's position \(0, 1, 2, ..., *size\(X\)-1*\) in X as its x-coordinate when performing the interpolation. You can also provide custom x-coordinates through the *index* parameter.

**Return value:** a numeric vector with null values filled in.

## Examples {#examples}

```
a=[NULL,NULL,1,2,NULL,NULL,5,6,NULL,NULL];

interpolate(a);
// output: [,,1,2,3,4,5,6,6,6]

interpolate(X=a, method="pad");
// output: [,,1,2,2,2,5,6,6,6]

interpolate(X=a, limitDirection='both');
// output: [1,1,1,2,3,4,5,6,6,6]

interpolate(X=a, limit=1, limitDirection='both');
// output: [,1,1,2,3,4,5,6,6,]

interpolate(X=a, limitDirection='both', limitArea='outside');
// output: [1,1,1,2,,,5,6,6,6]

a;
// output: [,,1,2,,,5,6,,]

interpolate(X=a, limitDirection='backward', inplace=true);
// output: [1,1,1,2,3,4,5,6,,]

a;
// output: [1,1,1,2,3,4,5,6,,]

dates=[2023.10.01, 2023.10.03, 2023.10.08, 2023.10.13, 2023.10.31, 2023.11.02, 2023.11.07, 2023.11.08,2023.11.09,2023.11.14]

interpolate(X=a,index=dates)
// output
[,,1,2,4.160000000000001,4.400000000000001,5,6,6,6]

a=[10,NULL,30,NULL,50];
index=[0, 3, 4, 7, 8]
interpolate(X=a,method='linear',index=index)
// output
[10,25,30,45,50]
```

