# installPlugin {#installplugin}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`installPlugin(pluginName, [pluginVersion], [pluginServerAddr])`

## Arguments {#arguments}

**pluginName** is a string indicating the plugin name.

**pluginVersion** \(optional\) is a string indicating the plugin version to install. If it is not specified, the latest version will be installed.

**pluginServerAddr** is a string indicating the HTTP address of the DolphinDB plugins repository that the system should use. It is recommended to specify it as "http://plugins.dolphindb.com/plugins".

## Details {#details}

Download and extract the shared library and the description file \(.txt\) of the specified plugin into your DolphinDB plugins directory. It returns the full path of the installed plugin description file, which is required when loading the plugin.

## Examples {#examples}

Download the mysql plugin on Linux:

```
loadPlugin("/home/DolphinDB_Linux64_V2.00.10/server/plugins/mysql/PluginMySQL.txt")
// Or
loadPlugin("mysql")

// output: /home/DolphinDB_Linux64/server/plugins/mysql/PluginMySQL.txt
```

Load the plugin via `loadPlugin`:

```
loadPlugin("/home/DolphinDB_Linux64/server/plugins/mysql/PluginMySQL.txt")
// Or you can use plugin name to load the plugin.
loadPlugin("mysql")
```

Related functions: [listRemoteLists](../l/listRemotePlugins.md), [loadPlugin](../l/loadPlugin.md)

