# initcap {#initcap}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`initcap(X)`

## Parameters {#parameters}

**X** is a STRING scalar/vector, or a SYMBOL vector.

## Details {#details}

The function returns an object of the same type/form as *X*.

For words separated by delimiters, the first letter of each word is in uppercase, and all other letters are in lowercase. The delimiters can be any character other than letters or numbers, such as spaces, @, etc.

**Note:**

Numbers are treated as letters.

## Examples {#examples}

```
initcap("hello world")
//output
Hello World

initcap("1aBBBBBB")
//output
1abbbbbb

initcap("nihao, hello@you")
//output
Nihao, Hello@You

initcap("你好hello" "hello You")
//output
["你好Hello","Hello You"]
initcap(symbol(["adhE","","1yI"]))
//output
["Adhe",,"1yi"]
```

