# indexedSeries {#indexedseries}

## Syntax {#syntax}

`indexedSeries(index, value)`

## Arguments {#arguments}

**index** and **value** are vectors of the same length. *index* must be monotonically increasing with no duplicate values.

## Details {#details}

`indexedSeries` supports alignment operations for panel data. When performing binary operations between matrices or vectors, calculations are performed on the corresponding elements, and the shape of these matrices or vectors must be the same.

But when performing binary operations between indexed series or between indexed series and indexed matrix, the data is automatically aligned according to the row or column labels \(index\), and the shape of the matrices or series can be the same or not.

The following binary operations are supported:

-   Arithmetic operators and functions: `+`, `-`, `*`, `/`\(exact division\), `\`\(`ratio`\), `%`\(`mod`\), `pow`

-   Logical operators and functions: `<`, `<=`, `>`, `>=`, `==`, `!=`, `<>`, `&&`, `||`, `&`, `|`, `^`

-   Sliding window functions: `mwavg`, `mwsum`, `mbeta`, `mcorr`, `mcovar`

-   Cumulative window functions: `cumwavg`, `cumwsum`, `cumbeta`, `cumcorr`, `cumcovar`

-   Aggregate functions: `wavg`, `wsum`, `beta`, `corr`, `covar`


## Examples {#examples}

Example 1. Length can be equal or unequal in operations between indexed series, The data is aligned according to the *index*.

```
s1 = indexedSeries(2012.01.01..2012.01.04, [10, 20, 30, 40])
s2 = indexedSeries(2011.12.30..2012.01.01, [50, 60, 70])
res = s1 + s2
```

||col1|
|---|----|
|2011.12.30||
|2011.12.31||
|2012.01.01|80|
|2012.01.02||
|2012.01.03||
|2012.01.04||

Example 2. In a calculation with an indexed series and a vector, the length must be equal.

```
s1 = indexedSeries(2012.01.01..2012.01.04, [10, 20, 30, 40])
v = [1,2,3,4]
res = s1+v
```

||col1|
|---|----|
|2012.01.01|11|
|2012.01.02|22|
|2012.01.03|33|
|2012.01.04|44|

Example 3. In a calculation with an indexed series and an indexed matrix, the inputs are aligned based on the *index*.

```
s1 = indexedSeries(2012.01.01 2012.01.03 2012.01.04 2012.01.06, [10, 20, 30, 40])
m = matrix(1..6, 11..16).rename!(2012.01.01..2012.01.06,`x`y).setIndexedMatrix!()
s1 + m
```

||IBM|MSFT|
|---|---|----|
|2012.01.01|11|21|
|2012.01.02|||
|2012.01.03|23|33|
|2012.01.04|34|44|
|2012.01.05|||
|2012.01.06|46|56|

Example 4. In a calculation with an indexed series and a matrix without *index*, they must be of the same length.

```
s1 = indexedSeries(2012.01.01..2012.01.04, [10, 20, 30, 40])
m = matrix([1,1,1,1], [2,2,2,2])
res = s1 pow m
```

|col1|col2|
|----|----|
|10|100|
|20|400|
|30|900|
|40|1,600|

