# iminLast {#iminlast}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`iminLast(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the position of the element with the smallest value. If there are multiple elements with the identical smallest value, return the position of the first element from the right. Same as other aggregate functions, null values are ignored.

If *X* is a matrix, return a vector containing the position of the element with the smallest value in each column.

If *X* is a table, return a table. Each column of the table contains the position of the element with the smallest value in the corresponding column of *X*.

## Examples {#examples}

``` {#codeblock_l5m_jj3_d1c}
x = 1.2 2 NULL -1 6 -1
iminLast(x);
// output: 5

m=matrix(3 2 2 4 2, 1 4 2 1 3);
iminLast(m) 
// output: [4,3]

t=table(3 2 2 as c1, 1 1 4 as c2)
iminLast(t)
/* output:
c1	c2
2	1
*/
```

Related function: [imin](imin.md)

