# imaxLast {#imaxlast}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`imaxLast(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the position of the element with the largest value. If there are multiple elements with the identical largest value, return the position of the first element from the right. Same as other aggregate functions, null values are ignored.

If *X* is a matrix, return a vector containing the position of the element with the largest value in each column.

If *X* is a table, return a table. Each column of the table contains the position of the element with the largest value in the corresponding column of *X*.

## Examples {#examples}

``` {#codeblock_qkx_qj3_d1c}
x = 1.2 2 NULL -1 6 -1
imaxLast(x);
// output: 4

m=matrix(3 2 4 4 2, 1 4 2 4 3);
imaxLast(m) 
// output: [3,3]

t=table(3 3 2 as c1, 1 4 4 as c2)
imaxLast(t)
/* output:
c1	c2
0	2
*/
```

Related function: [imax](imax.md)

