# ilike {#ilike}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ilike(X, pattern)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix.

**pattern** is a string and is usually used with wildcard character %.

## Details {#details}

Return a Boolean value scalar or vector indicating whether each element in *X* fits a specific pattern. The comparison is case insensitive.

The wildcard charater % indicates 0 or more characters.

## Examples {#examples}

```
ilike(`ABCDEFG, `de);
// output: 0

ilike(`ABCDEFG, "%de%");
// output: 1

a=`IBM`ibm`MSFT`Goog`YHOO`ORCL;
a ilike  "%OO%";
// output: [0,0,0,1,1,0]

a[a ilike  "%OO%"];
// output: ["Goog","YHOO"]
```

Related function: [like](../l/like.md)

